/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelModifier;
import net.minecraft.class_3532;
import net.minecraft.class_5253;

public class ContrastModifier
implements PixelModifier {
    protected final float contrast;

    public ContrastModifier(float contrast) {
        Preconditions.checkArgument((contrast > 0.0f ? 1 : 0) != 0, (Object)"Contrast should be larger than 0.");
        this.contrast = contrast;
    }

    public ContrastModifier() {
        this(1.0f);
    }

    @Override
    public String getIdentifier() {
        return "contrast-" + this.contrast;
    }

    @Override
    public int modify(int colorARGB) {
        if (this.contrast == 1.0f) {
            return colorARGB;
        }
        int alpha = class_5253.class_5254.method_27762((int)colorARGB);
        int red = class_5253.class_5254.method_27765((int)colorARGB);
        int green = class_5253.class_5254.method_27766((int)colorARGB);
        int blue = class_5253.class_5254.method_27767((int)colorARGB);
        int contrastValue = Math.round(127.0f * this.contrast);
        red = class_3532.method_15340((int)((red - 127) * contrastValue / 127 + 127), (int)0, (int)255);
        green = class_3532.method_15340((int)((green - 127) * contrastValue / 127 + 127), (int)0, (int)255);
        blue = class_3532.method_15340((int)((blue - 127) * contrastValue / 127 + 127), (int)0, (int)255);
        return class_5253.class_5254.method_27764((int)alpha, (int)red, (int)green, (int)blue);
    }

    public String toString() {
        return "Contrast{contrast=" + this.contrast + "}";
    }
}

